/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.boot;

import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.IOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DownloadUtils {
    private static final String MAVEN_METADATA_URL = "${REPO}/com/taobao/arthas/arthas-packaging/maven-metadata.xml";
    private static final String REMOTE_DOWNLOAD_URL = "${REPO}/com/taobao/arthas/arthas-packaging/${VERSION}/arthas-packaging-${VERSION}-bin.zip";
    private static final int CONNECTION_TIMEOUT = 3000;

    public static String readMavenReleaseVersion(String mavenMetaData) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(mavenMetaData.getBytes("UTF-8"));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(inputStream);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("release");
            return nodeList.item(0).getTextContent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> readAllMavenVersion(String mavenMetaData) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(mavenMetaData.getBytes("UTF-8"));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(inputStream);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("version");
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                result.add(nodeList.item(i).getTextContent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static String readMavenMetaData(String repoMirror, boolean http) {
        String string;
        String repoUrl = DownloadUtils.getRepoUrl(repoMirror, http);
        String metaDataUrl = MAVEN_METADATA_URL.replace("${REPO}", repoUrl);
        AnsiLog.debug("Download maven-metadata.xml from: {}", metaDataUrl);
        InputStream inputStream = null;
        try {
            URLConnection connection = DownloadUtils.openURLConnection(metaDataUrl);
            inputStream = connection.getInputStream();
            string = IOUtils.toString(inputStream);
        }
        catch (SSLException e) {
            AnsiLog.error("TLS connect error, please try to use --use-http argument.");
            AnsiLog.error("URL: " + metaDataUrl);
            AnsiLog.error(e);
            IOUtils.close(inputStream);
        }
        catch (Throwable t) {
            AnsiLog.error("Can not read maven-metadata.xml from: " + metaDataUrl);
            AnsiLog.debug(t);
            {
                catch (Throwable throwable) {
                    IOUtils.close(inputStream);
                    throw throwable;
                }
            }
            IOUtils.close(inputStream);
        }
        IOUtils.close(inputStream);
        return string;
        return null;
    }

    public static String getRepoUrl(String repoMirror, boolean http) {
        repoMirror = repoMirror.trim();
        String repoUrl = "";
        repoUrl = repoMirror.equals("center") ? "https://repo1.maven.org/maven2" : (repoMirror.equals("aliyun") ? "https://maven.aliyun.com/repository/public" : repoMirror);
        if (repoUrl.endsWith("/")) {
            repoUrl = repoUrl.substring(0, repoUrl.length() - 1);
        }
        if (http && repoUrl.startsWith("https")) {
            repoUrl = "http" + repoUrl.substring("https".length(), repoUrl.length());
        }
        return repoUrl;
    }

    public static void downArthasPackaging(String repoMirror, boolean http, String arthasVersion, String savePath) throws ParserConfigurationException, SAXException, IOException {
        String repoUrl = DownloadUtils.getRepoUrl(repoMirror, http);
        File unzipDir = new File(savePath, arthasVersion + File.separator + "arthas");
        File tempFile = File.createTempFile("arthas", "arthas");
        AnsiLog.debug("Arthas download temp file: " + tempFile.getAbsolutePath());
        String remoteDownloadUrl = REMOTE_DOWNLOAD_URL.replace("${REPO}", repoUrl).replace("${VERSION}", arthasVersion);
        AnsiLog.info("Start download arthas from remote server: " + remoteDownloadUrl);
        DownloadUtils.saveUrl(tempFile.getAbsolutePath(), remoteDownloadUrl, true);
        AnsiLog.info("Download arthas success.");
        IOUtils.unzip(tempFile.getAbsolutePath(), unzipDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUrl(String filename, String urlString, boolean printProgress) throws MalformedURLException, IOException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            String contentLength;
            URLConnection connection = DownloadUtils.openURLConnection(urlString);
            in = new BufferedInputStream(connection.getInputStream());
            List<String> values = connection.getHeaderFields().get("Content-Length");
            int fileSize = 0;
            if (values != null && !values.isEmpty() && (contentLength = values.get(0)) != null) {
                fileSize = Integer.parseInt(contentLength);
            }
            fout = new FileOutputStream(filename);
            byte[] data = new byte[0x100000];
            int totalCount = 0;
            long lastPrintTime = System.currentTimeMillis();
            while ((count = in.read(data, 0, 0x100000)) != -1) {
                long now;
                totalCount += count;
                if (printProgress && (now = System.currentTimeMillis()) - lastPrintTime > 1000L) {
                    AnsiLog.info("File size: {}, downloaded size: {}, downloading ...", DownloadUtils.formatFileSize(fileSize), DownloadUtils.formatFileSize(totalCount));
                    lastPrintTime = now;
                }
                fout.write(data, 0, count);
            }
        }
        catch (SSLException e) {
            try {
                AnsiLog.error("TLS connect error, please try to add --use-http argument.");
                AnsiLog.error("URL: " + urlString);
                AnsiLog.error(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                IOUtils.close(fout);
                throw throwable;
            }
            IOUtils.close(in);
            IOUtils.close(fout);
        }
        IOUtils.close(in);
        IOUtils.close(fout);
    }

    private static URLConnection openURLConnection(String url) throws MalformedURLException, IOException {
        URLConnection connection = new URL(url).openConnection();
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setConnectTimeout(3000);
            int status = ((HttpURLConnection)connection).getResponseCode();
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                String newUrl = ((HttpURLConnection)connection).getHeaderField("Location");
                AnsiLog.debug("Try to open url: {}, redirect to: {}", url, newUrl);
                return DownloadUtils.openURLConnection(newUrl);
            }
        }
        return connection;
    }

    private static String formatFileSize(long size) {
        String hrSize = null;
        double b = size;
        double k = (double)size / 1024.0;
        double m = (double)size / 1024.0 / 1024.0;
        double g = (double)size / 1024.0 / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : (m > 1.0 ? dec.format(m).concat(" MB") : (k > 1.0 ? dec.format(k).concat(" KB") : dec.format(b).concat(" Bytes"))));
        return hrSize;
    }
}

