/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.ssh.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.termd.core.ssh.netty.NettyIoAcceptor;
import io.termd.core.ssh.netty.NettyIoHandlerBridge;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class NettyIoServiceFactory
extends AbstractCloseable
implements IoServiceFactory {
    final NettyIoHandlerBridge handlerBridge;
    final EventLoopGroup eventLoopGroup;
    final boolean closeEventLoopGroup;

    public NettyIoServiceFactory() {
        this(null);
    }

    public NettyIoServiceFactory(EventLoopGroup group) {
        this(group, new NettyIoHandlerBridge());
    }

    public NettyIoServiceFactory(EventLoopGroup group, NettyIoHandlerBridge handlerBridge) {
        this.handlerBridge = handlerBridge;
        this.closeEventLoopGroup = group == null;
        this.eventLoopGroup = group == null ? new NioEventLoopGroup() : group;
    }

    public IoConnector createConnector(IoHandler handler) {
        throw new UnsupportedOperationException("Only implement server for now");
    }

    public IoAcceptor createAcceptor(IoHandler handler) {
        return new NettyIoAcceptor(this, handler);
    }

    protected CloseFuture doCloseGracefully() {
        if (this.closeEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully().addListener(new GenericFutureListener<Future<Object>>(){

                @Override
                public void operationComplete(Future<Object> future) throws Exception {
                    NettyIoServiceFactory.this.closeFuture.setClosed();
                }
            });
        } else {
            this.closeFuture.setClosed();
        }
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.doCloseGracefully();
        super.doCloseImmediately();
    }
}

