/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.ObjectView;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.ui.TreeElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TypeRenderUtils {
    public static String drawAnnotation(Class<?> clazz) {
        return TypeRenderUtils.drawAnnotation(clazz.getDeclaredAnnotations());
    }

    public static String drawAnnotation(Method method) {
        return TypeRenderUtils.drawAnnotation(method.getDeclaredAnnotations());
    }

    public static String drawInterface(Class<?> clazz) {
        return StringUtils.concat(",", clazz.getInterfaces());
    }

    public static String drawParameters(Method method) {
        return StringUtils.concat("\n", method.getParameterTypes());
    }

    public static String drawParameters(Constructor constructor) {
        return StringUtils.concat("\n", constructor.getParameterTypes());
    }

    public static String drawReturn(Method method) {
        return StringUtils.classname(method.getReturnType());
    }

    public static String drawExceptions(Method method) {
        return StringUtils.concat("\n", method.getExceptionTypes());
    }

    public static String drawExceptions(Constructor constructor) {
        return StringUtils.concat("\n", constructor.getExceptionTypes());
    }

    public static Element drawSuperClass(Class<?> clazz) {
        TreeElement root;
        TreeElement parent = root = new TreeElement();
        Class<?> superClass = clazz.getSuperclass();
        if (null != superClass) {
            TreeElement child = new TreeElement(Element.label(StringUtils.classname(superClass)));
            parent.addChild(child);
            parent = child;
            while (null != (superClass = superClass.getSuperclass())) {
                TreeElement tempChild = new TreeElement(Element.label(StringUtils.classname(superClass)));
                parent.addChild(tempChild);
                parent = tempChild;
            }
        }
        return root;
    }

    public static Element drawClassLoader(Class<?> clazz) {
        TreeElement root;
        TreeElement parent = root = new TreeElement();
        ClassLoader loader = clazz.getClassLoader();
        if (null != loader) {
            TreeElement child = new TreeElement(Element.label(loader.toString()));
            parent.addChild(child);
            parent = child;
            while (null != (loader = loader.getParent())) {
                TreeElement tempChild = new TreeElement(Element.label(loader.toString()));
                parent.addChild(tempChild);
                parent = tempChild;
            }
        }
        return root;
    }

    public static Element drawField(Class<?> clazz, Integer expand) {
        TableElement fieldsTable = new TableElement().leftCellPadding(0).rightCellPadding(0);
        Field[] fields = clazz.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return fieldsTable;
        }
        for (Field field : fields) {
            TableElement fieldTable = new TableElement().leftCellPadding(0).rightCellPadding(0);
            fieldTable.row("modifier", StringUtils.modifier(field.getModifiers(), ',')).row("type", StringUtils.classname(field.getType())).row("name", field.getName());
            Annotation[] annotations = field.getAnnotations();
            if (annotations != null && annotations.length > 0) {
                fieldTable.row("annotation", TypeRenderUtils.drawAnnotation(annotations));
            }
            if (Modifier.isStatic(field.getModifiers())) {
                fieldTable.row("value", TypeRenderUtils.drawFieldValue(field, expand));
            }
            fieldTable.row(Element.label(""));
            fieldsTable.row(fieldTable);
        }
        return fieldsTable;
    }

    public static String renderMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.modifier(method.getModifiers(), ' ')).append(" ");
        sb.append(TypeRenderUtils.drawReturn(method)).append(" ");
        sb.append(method.getName()).append(" ");
        sb.append("(");
        sb.append(StringUtils.concat(", ", method.getParameterTypes()));
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String drawFieldValue(Field field, Integer expand) {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object value = field.get(null);
            Object o = expand != null && expand >= 0 ? new ObjectView(value, expand).draw() : value;
            String string = StringUtils.objectToString(o);
            return string;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        finally {
            field.setAccessible(isAccessible);
        }
        return "";
    }

    public static String drawAnnotation(Annotation ... annotations) {
        List<Class> types = Collections.emptyList();
        if (annotations != null && annotations.length > 0) {
            types = new LinkedList();
            for (Annotation annotation : annotations) {
                types.add(annotation.annotationType());
            }
        }
        return StringUtils.concat(",", types.toArray(new Class[0]));
    }
}

