/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;

public class NetUtils {
    private static final String QOS_HOST = "localhost";
    private static final int QOS_PORT = 12201;
    private static final String QOS_RESPONSE_START_LINE = "pandora>[QOS Response]";
    private static final int INTERNAL_SERVER_ERROR = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response request(String urlString) {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Accept", "application/json,text/plain;q=0.2");
            BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            int statusCode = urlConnection.getResponseCode();
            String result = sb.toString().trim();
            if (statusCode == 500) {
                JSONObject errorObj = JSON.parseObject(result);
                if (errorObj.containsKey("errorMsg")) {
                    Response response = new Response(errorObj.getString("errorMsg"), false);
                    return response;
                }
                Response response = new Response(result, false);
                return response;
            }
            Response response = new Response(result);
            return response;
        }
        catch (IOException e) {
            Response response = new Response(e.getMessage(), false);
            return response;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String simpleRequest(String url) {
        BufferedReader br = null;
        try {
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestProperty("Accept", "application/json");
            int responseCode = con.getResponseCode();
            br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String result = sb.toString().trim();
            if (responseCode == 500) {
                JSONObject errorObj = JSON.parseObject(result);
                if (errorObj.containsKey("errorMsg")) {
                    String string = errorObj.getString("errorMsg");
                    return string;
                }
                String string = result;
                return string;
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response requestViaSocket(String path) {
        BufferedReader br = null;
        try {
            Socket s = new Socket(QOS_HOST, 12201);
            PrintWriter pw = new PrintWriter(s.getOutputStream());
            pw.println("GET " + path + " HTTP/1.1");
            pw.println("Host: localhost:12201");
            pw.println("");
            pw.flush();
            br = new BufferedReader(new InputStreamReader(s.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = null;
            boolean start = false;
            while ((line = br.readLine()) != null) {
                if (start) {
                    sb.append(line).append("\n");
                }
                if (!line.equals(QOS_RESPONSE_START_LINE)) continue;
                start = true;
            }
            String result = sb.toString().trim();
            Response response = new Response(result);
            return response;
        }
        catch (Exception e) {
            Response response = new Response(e.getMessage(), false);
            return response;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serverListening(String host, int port) {
        Socket s = null;
        try {
            s = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class Response {
        private boolean success;
        private String content;

        public Response(String content, boolean success) {
            this.success = success;
            this.content = content;
        }

        public Response(String content) {
            this.content = content;
            this.success = true;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getContent() {
            return this.content;
        }
    }
}

