/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import java.security.CodeSource;

public class ClassUtils {
    public static String getCodeSource(CodeSource cs) {
        if (null == cs || null == cs.getLocation() || null == cs.getLocation().getFile()) {
            return "";
        }
        return cs.getLocation().getFile();
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.getName().contains("$$Lambda$");
    }

    public static Element renderClassInfo(Class<?> clazz) {
        return ClassUtils.renderClassInfo(clazz, false, null);
    }

    public static Element renderClassInfo(Class<?> clazz, boolean isPrintField, Integer expand) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        table.row(Element.label("class-info").style(Decoration.bold.bold()), Element.label(StringUtils.classname(clazz))).row(Element.label("code-source").style(Decoration.bold.bold()), Element.label(ClassUtils.getCodeSource(cs))).row(Element.label("name").style(Decoration.bold.bold()), Element.label(StringUtils.classname(clazz))).row(Element.label("isInterface").style(Decoration.bold.bold()), Element.label("" + clazz.isInterface())).row(Element.label("isAnnotation").style(Decoration.bold.bold()), Element.label("" + clazz.isAnnotation())).row(Element.label("isEnum").style(Decoration.bold.bold()), Element.label("" + clazz.isEnum())).row(Element.label("isAnonymousClass").style(Decoration.bold.bold()), Element.label("" + clazz.isAnonymousClass())).row(Element.label("isArray").style(Decoration.bold.bold()), Element.label("" + clazz.isArray())).row(Element.label("isLocalClass").style(Decoration.bold.bold()), Element.label("" + clazz.isLocalClass())).row(Element.label("isMemberClass").style(Decoration.bold.bold()), Element.label("" + clazz.isMemberClass())).row(Element.label("isPrimitive").style(Decoration.bold.bold()), Element.label("" + clazz.isPrimitive())).row(Element.label("isSynthetic").style(Decoration.bold.bold()), Element.label("" + clazz.isSynthetic())).row(Element.label("simple-name").style(Decoration.bold.bold()), Element.label(clazz.getSimpleName())).row(Element.label("modifier").style(Decoration.bold.bold()), Element.label(StringUtils.modifier(clazz.getModifiers(), ','))).row(Element.label("annotation").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawAnnotation(clazz))).row(Element.label("interfaces").style(Decoration.bold.bold()), Element.label(TypeRenderUtils.drawInterface(clazz))).row(Element.label("super-class").style(Decoration.bold.bold()), TypeRenderUtils.drawSuperClass(clazz)).row(Element.label("class-loader").style(Decoration.bold.bold()), TypeRenderUtils.drawClassLoader(clazz)).row(Element.label("classLoaderHash").style(Decoration.bold.bold()), Element.label(StringUtils.classLoaderHash(clazz)));
        if (isPrintField) {
            table.row(Element.label("fields"), TypeRenderUtils.drawField(clazz, expand));
        }
        return table;
    }
}

