/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl;

import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.CliTokens;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.term.impl.CompletionAdaptor;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.middleware.logger.Logger;
import io.termd.core.function.Consumer;
import io.termd.core.readline.Completion;
import io.termd.core.util.Helper;
import java.util.Collections;
import java.util.List;

class CompletionHandler
implements Consumer<Completion> {
    private static final Logger logger = LogUtil.getArthasLogger();
    private final Handler<com.taobao.arthas.core.shell.cli.Completion> completionHandler;
    private final Session session;

    public CompletionHandler(Handler<com.taobao.arthas.core.shell.cli.Completion> completionHandler, Session session) {
        this.completionHandler = completionHandler;
        this.session = session;
    }

    @Override
    public void accept(Completion completion) {
        try {
            String line = Helper.fromCodePoints(completion.line());
            List<CliToken> tokens = Collections.unmodifiableList(CliTokens.tokenize(line));
            CompletionAdaptor comp = new CompletionAdaptor(line, tokens, completion, this.session);
            this.completionHandler.handle(comp);
        }
        catch (Throwable t) {
            logger.error(null, "completion error", t);
        }
    }
}

