/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.cli.impl;

import com.taobao.arthas.core.shell.cli.CliToken;
import io.termd.core.readline.LineStatus;
import java.util.LinkedList;
import java.util.List;

public class CliTokenImpl
implements CliToken {
    final boolean text;
    final String raw;
    final String value;

    public CliTokenImpl(boolean text, String value) {
        this(text, value, value);
    }

    public CliTokenImpl(boolean text, String raw, String value) {
        this.text = text;
        this.raw = raw;
        this.value = value;
    }

    @Override
    public boolean isText() {
        return this.text;
    }

    @Override
    public boolean isBlank() {
        return !this.text;
    }

    @Override
    public String raw() {
        return this.raw;
    }

    @Override
    public String value() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CliTokenImpl) {
            CliTokenImpl that = (CliTokenImpl)obj;
            return this.text == that.text && this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return "CliToken[text=" + this.text + ",value=" + this.value + "]";
    }

    public static List<CliToken> tokenize(String s) {
        LinkedList<CliToken> tokens = new LinkedList<CliToken>();
        CliTokenImpl.tokenize(s, 0, tokens);
        return tokens;
    }

    private static void tokenize(String s, int index, List<CliToken> builder) {
        block3: while (index < s.length()) {
            char c = s.charAt(index);
            switch (c) {
                case '\t': 
                case ' ': {
                    index = CliTokenImpl.blankToken(s, index, builder);
                    continue block3;
                }
            }
            index = CliTokenImpl.textToken(s, index, builder);
        }
    }

    private static int textToken(String s, int index, List<CliToken> builder) {
        LineStatus quoter = new LineStatus();
        int from = index;
        StringBuilder value = new StringBuilder();
        while (index < s.length()) {
            char c = s.charAt(index);
            quoter.accept(c);
            if (!quoter.isQuoted() && !quoter.isEscaped() && CliTokenImpl.isBlank(c)) break;
            if (quoter.isCodePoint()) {
                if (quoter.isEscaped() && quoter.isWeaklyQuoted() && c != '\"') {
                    value.append('\\');
                }
                value.append(c);
            }
            ++index;
        }
        builder.add(new CliTokenImpl(true, s.substring(from, index), value.toString()));
        return index;
    }

    private static int blankToken(String s, int index, List<CliToken> builder) {
        int from = index;
        while (index < s.length() && CliTokenImpl.isBlank(s.charAt(index))) {
            ++index;
        }
        builder.add(new CliTokenImpl(false, s.substring(from, index)));
        return index;
    }

    private static boolean isBlank(char c) {
        return c == ' ' || c == '\t';
    }
}

