/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.config;

import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class FeatureCodec {
    private final char kvSegmentSeparator;
    private final char kvSeparator;
    private static final char ESCAPE_PREFIX_CHAR = '\\';

    public FeatureCodec(char kvSegmentSeparator, char kvSeparator) {
        if (ArthasCheckUtils.isIn(Character.valueOf('\\'), Character.valueOf(kvSegmentSeparator), Character.valueOf(kvSeparator))) {
            throw new IllegalArgumentException("separator can not init to '\\'.");
        }
        this.kvSegmentSeparator = kvSegmentSeparator;
        this.kvSeparator = kvSeparator;
    }

    public String toString(Map<String, String> map) {
        StringBuilder featureSB = new StringBuilder().append(this.kvSegmentSeparator);
        if (null == map || map.isEmpty()) {
            return featureSB.toString();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            featureSB.append(this.escapeEncode(entry.getKey())).append(this.kvSeparator).append(this.escapeEncode(entry.getValue())).append(this.kvSegmentSeparator);
        }
        return featureSB.toString();
    }

    public Map<String, String> toMap(String featureString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank(featureString)) {
            return map;
        }
        for (String kv : this.escapeSplit(featureString, this.kvSegmentSeparator)) {
            String[] ar;
            if (StringUtils.isBlank(kv) || (ar = this.escapeSplit(kv, this.kvSeparator)).length != 2) continue;
            String k = ar[0];
            String v = ar[1];
            if (StringUtils.isBlank(k) || StringUtils.isBlank(v)) continue;
            map.put(this.escapeDecode(k), this.escapeDecode(v));
        }
        return map;
    }

    private String escapeEncode(String string) {
        StringBuilder returnSB = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (ArthasCheckUtils.isIn(Character.valueOf(c), Character.valueOf(this.kvSegmentSeparator), Character.valueOf(this.kvSeparator), Character.valueOf('\\'))) {
                returnSB.append('\\');
            }
            returnSB.append(c);
        }
        return returnSB.toString();
    }

    private String escapeDecode(String string) {
        StringBuilder segmentSB = new StringBuilder();
        int stringLength = string.length();
        for (int index = 0; index < stringLength; ++index) {
            char c = string.charAt(index);
            if (ArthasCheckUtils.isEquals(Character.valueOf(c), Character.valueOf('\\')) && index < stringLength - 1) {
                char nextChar;
                if (ArthasCheckUtils.isIn(Character.valueOf(nextChar = string.charAt(++index)), Character.valueOf(this.kvSegmentSeparator), Character.valueOf(this.kvSeparator), Character.valueOf('\\'))) {
                    segmentSB.append(nextChar);
                    continue;
                }
                segmentSB.append(c);
                segmentSB.append(nextChar);
                continue;
            }
            segmentSB.append(c);
        }
        return segmentSB.toString();
    }

    private String[] escapeSplit(String string, char splitEscapeChar) {
        ArrayList<String> segmentArrayList = new ArrayList<String>();
        Stack<Character> decodeStack = new Stack<Character>();
        int stringLength = string.length();
        for (int index = 0; index < stringLength; ++index) {
            boolean isArchive = false;
            char c = string.charAt(index);
            if (ArthasCheckUtils.isEquals(Character.valueOf(c), Character.valueOf('\\'))) {
                decodeStack.push(Character.valueOf(c));
                if (index < stringLength - 1) {
                    char nextChar = string.charAt(++index);
                    decodeStack.push(Character.valueOf(nextChar));
                }
            } else if (ArthasCheckUtils.isEquals(Character.valueOf(c), Character.valueOf(splitEscapeChar))) {
                isArchive = true;
            } else {
                decodeStack.push(Character.valueOf(c));
            }
            if (!isArchive && index != stringLength - 1) continue;
            StringBuilder segmentSB = new StringBuilder(decodeStack.size());
            while (!decodeStack.isEmpty()) {
                segmentSB.append(decodeStack.pop());
            }
            segmentArrayList.add(segmentSB.reverse().toString().trim());
        }
        return segmentArrayList.toArray(new String[0]);
    }
}

