/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.command.monitor200.EnhancerCommand;
import com.taobao.arthas.core.command.monitor200.TimeFragment;
import com.taobao.arthas.core.command.monitor200.TimeTunnelAdviceListener;
import com.taobao.arthas.core.command.monitor200.TimeTunnelTable;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.view.ObjectView;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Name(value="tt")
@Summary(value="Time Tunnel")
@Description(value="  The express may be one of the following expression (evaluated dynamically):\n          target : the object\n           clazz : the object's class\n          method : the constructor or method\n          params : the parameters array of method\n    params[0..n] : the element of parameters array\n       returnObj : the returned object of method\n        throwExp : the throw exception of method\n        isReturn : the method ended by return\n         isThrow : the method ended by throwing exception\n           #cost : the execution time in ms of method invocation\nEXAMPLES:\n  tt -t *StringUtils isEmpty\n  tt -t *StringUtils isEmpty params[0].length==1\n  tt -l\n  tt -i 1000\n  tt -i 1000 -w params[0]\n  tt -i 1000 -p \n  tt -i 1000 -p --replay-times 3 --replay-interval 3000\n  tt --delete-all\n\nWIKI:\n  https://alibaba.github.io/arthas/tt")
public class TimeTunnelCommand
extends EnhancerCommand {
    private static final Map<Integer, TimeFragment> timeFragmentMap = new LinkedHashMap<Integer, TimeFragment>();
    private static final AtomicInteger sequence = new AtomicInteger(1000);
    private boolean isTimeTunnel = false;
    private String classPattern;
    private String methodPattern;
    private String conditionExpress;
    private boolean isList = false;
    private boolean isDeleteAll = false;
    private Integer index;
    private Integer expand = 1;
    private Integer sizeLimit = 0xA00000;
    private String watchExpress = "";
    private String searchExpress = "";
    private boolean isPlay = false;
    private boolean isDelete = false;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;
    private int replayTimes = 1;
    private long replayInterval = 1000L;
    private static final Logger logger = LogUtil.getArthasLogger();

    @Argument(index=0, argName="class-pattern", required=false)
    @Description(value="Path and classname of Pattern Matching")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(index=1, argName="method-pattern", required=false)
    @Description(value="Method of Pattern Matching")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Argument(index=2, argName="condition-express", required=false)
    @Description(value="Conditional expression in ognl style, for example:\n  TRUE  : 1==1\n  TRUE  : true\n  FALSE : false\n  TRUE  : 'params.length>=0'\n  FALSE : 1==2\n")
    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    @Option(shortName="t", longName="time-tunnel", flag=true)
    @Description(value="Record the method invocation within time fragments")
    public void setTimeTunnel(boolean timeTunnel) {
        this.isTimeTunnel = timeTunnel;
    }

    @Option(shortName="l", longName="list", flag=true)
    @Description(value="List all the time fragments")
    public void setList(boolean list) {
        this.isList = list;
    }

    @Option(longName="delete-all", flag=true)
    @Description(value="Delete all the time fragments")
    public void setDeleteAll(boolean deleteAll) {
        this.isDeleteAll = deleteAll;
    }

    @Option(shortName="i", longName="index")
    @Description(value="Display the detailed information from specified time fragment")
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (1 by default)")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    @Option(shortName="M", longName="sizeLimit")
    @Description(value="Upper size limit in bytes for the result (10 * 1024 * 1024 by default)")
    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Option(shortName="w", longName="watch-express")
    @Description(value="watch the time fragment by ognl express.\nExamples:\n  params\n  params[0]\n  'params[0]+params[1]'\n  '{params[0], target, returnObj}'\n  returnObj\n  throwExp\n  target\n  clazz\n  method\n")
    public void setWatchExpress(String watchExpress) {
        this.watchExpress = watchExpress;
    }

    @Option(shortName="s", longName="search-express")
    @Description(value="Search-expression, to search the time fragments by ognl express.\nThe structure of 'advice' like conditional expression")
    public void setSearchExpress(String searchExpress) {
        this.searchExpress = searchExpress;
    }

    @Option(shortName="p", longName="play", flag=true)
    @Description(value="Replay the time fragment specified by index")
    public void setPlay(boolean play) {
        this.isPlay = play;
    }

    @Option(shortName="d", longName="delete", flag=true)
    @Description(value="Delete time fragment specified by index")
    public void setDelete(boolean delete) {
        this.isDelete = delete;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Threshold of execution times")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    @Option(longName="replay-times")
    @Description(value="execution times when play tt")
    public void setReplayTimes(int replayTimes) {
        this.replayTimes = replayTimes;
    }

    @Option(longName="replay-interval")
    @Description(value="replay interval  for  play tt with option r greater than 1")
    public void setReplayInterval(int replayInterval) {
        this.replayInterval = replayInterval;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    public int getReplayTimes() {
        return this.replayTimes;
    }

    public long getReplayInterval() {
        return this.replayInterval;
    }

    private boolean hasWatchExpress() {
        return !StringUtils.isEmpty(this.watchExpress);
    }

    private boolean hasSearchExpress() {
        return !StringUtils.isEmpty(this.searchExpress);
    }

    private boolean isNeedExpand() {
        return null != this.expand && this.expand > 0;
    }

    private void checkArguments() {
        if ((this.isDelete || this.isPlay) && null == this.index) {
            throw new IllegalArgumentException("Time fragment index is expected, please type -i to specify");
        }
        if (this.isTimeTunnel) {
            if (StringUtils.isEmpty(this.classPattern)) {
                throw new IllegalArgumentException("Class-pattern is expected, please type the wildcard expression to match");
            }
            if (StringUtils.isEmpty(this.methodPattern)) {
                throw new IllegalArgumentException("Method-pattern is expected, please type the wildcard expression to match");
            }
        }
        if (null == this.index && !this.isTimeTunnel && !this.isDeleteAll && StringUtils.isEmpty(this.watchExpress) && !this.isList && StringUtils.isEmpty(this.searchExpress)) {
            throw new IllegalArgumentException("Argument(s) is/are expected, type 'help tt' to read usage");
        }
    }

    int putTimeTunnel(TimeFragment tt) {
        int indexOfSeq = sequence.getAndIncrement();
        timeFragmentMap.put(indexOfSeq, tt);
        return indexOfSeq;
    }

    @Override
    public void process(CommandProcess process) {
        this.checkArguments();
        process.interruptHandler(new CommandInterruptHandler(process));
        process.stdinHandler(new QExitHandler(process));
        if (this.isTimeTunnel) {
            this.enhance(process);
        } else if (this.isPlay) {
            this.processPlay(process);
        } else if (this.isList) {
            this.processList(process);
        } else if (this.isDeleteAll) {
            this.processDeleteAll(process);
        } else if (this.isDelete) {
            this.processDelete(process);
        } else if (this.hasSearchExpress()) {
            this.processSearch(process);
        } else if (this.index != null) {
            if (this.hasWatchExpress()) {
                this.processWatch(process);
            } else {
                this.processShow(process);
            }
        }
    }

    @Override
    protected Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx());
        }
        return this.classNameMatcher;
    }

    @Override
    protected Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = SearchUtils.classNameMatcher(this.getMethodPattern(), this.isRegEx());
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(CommandProcess process) {
        return new TimeTunnelAdviceListener(this, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processShow(CommandProcess process) {
        RowAffect affect = new RowAffect();
        try {
            TimeFragment tf = timeFragmentMap.get(this.index);
            if (null == tf) {
                process.write(String.format("Time fragment[%d] does not exist.", this.index)).write("\n");
                return;
            }
            Advice advice = tf.getAdvice();
            String className = advice.getClazz().getName();
            String methodName = advice.getMethod().getName();
            String objectAddress = advice.getTarget() == null ? "NULL" : "0x" + Integer.toHexString(advice.getTarget().hashCode());
            TableElement table = TimeTunnelTable.createDefaultTable();
            TimeTunnelTable.drawTimeTunnel(tf, this.index, table);
            TimeTunnelTable.drawMethod(advice, className, methodName, objectAddress, table);
            TimeTunnelTable.drawParameters(advice, table, this.isNeedExpand(), this.expand);
            TimeTunnelTable.drawReturnObj(advice, table, this.isNeedExpand(), this.expand, this.sizeLimit);
            TimeTunnelTable.drawThrowException(advice, table, this.isNeedExpand(), this.expand);
            process.write(RenderUtil.render(table, process.width()));
            affect.rCnt(1);
        }
        finally {
            process.write(affect.toString()).write("\n");
            process.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWatch(CommandProcess process) {
        RowAffect affect = new RowAffect();
        try {
            TimeFragment tf = timeFragmentMap.get(this.index);
            if (null == tf) {
                process.write(String.format("Time fragment[%d] does not exist.", this.index)).write("\n");
                return;
            }
            Advice advice = tf.getAdvice();
            Object value = ExpressFactory.threadLocalExpress(advice).get(this.watchExpress);
            if (this.isNeedExpand()) {
                process.write(new ObjectView(value, this.expand, this.sizeLimit).draw()).write("\n");
            } else {
                process.write(StringUtils.objectToString(value)).write("\n");
            }
            affect.rCnt(1);
        }
        catch (ExpressException e) {
            logger.warn("tt failed.", e);
            process.write(e.getMessage() + ", visit " + LogUtil.LOGGER_FILE + " for more detail\n");
        }
        finally {
            process.write(affect.toString()).write("\n");
            process.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSearch(CommandProcess process) {
        RowAffect affect = new RowAffect();
        try {
            LinkedHashMap<Integer, TimeFragment> matchingTimeSegmentMap = new LinkedHashMap<Integer, TimeFragment>();
            for (Map.Entry<Integer, TimeFragment> entry : timeFragmentMap.entrySet()) {
                int index = entry.getKey();
                TimeFragment tf = entry.getValue();
                Advice advice = tf.getAdvice();
                if (!ExpressFactory.threadLocalExpress(advice).is(this.searchExpress)) continue;
                matchingTimeSegmentMap.put(index, tf);
            }
            if (this.hasWatchExpress()) {
                TableElement table = TimeTunnelTable.createDefaultTable();
                TimeTunnelTable.drawWatchTableHeader(table);
                TimeTunnelTable.drawWatchExpress(matchingTimeSegmentMap, table, this.watchExpress, this.isNeedExpand(), this.expand, this.sizeLimit);
                process.write(RenderUtil.render(table, process.width()));
            } else {
                process.write(RenderUtil.render(TimeTunnelTable.drawTimeTunnelTable(matchingTimeSegmentMap), process.width()));
            }
            affect.rCnt(matchingTimeSegmentMap.size());
        }
        catch (ExpressException e) {
            LogUtil.getArthasLogger().warn("tt failed.", e);
            process.write(e.getMessage() + ", visit " + LogUtil.LOGGER_FILE + " for more detail\n");
        }
        finally {
            process.write(affect.toString()).write("\n");
            process.end();
        }
    }

    private void processDelete(CommandProcess process) {
        RowAffect affect = new RowAffect();
        if (timeFragmentMap.remove(this.index) != null) {
            affect.rCnt(1);
        }
        process.write(String.format("Time fragment[%d] successfully deleted.", this.index)).write("\n");
        process.write(affect.toString()).write("\n");
        process.end();
    }

    private void processDeleteAll(CommandProcess process) {
        int count = timeFragmentMap.size();
        RowAffect affect = new RowAffect(count);
        timeFragmentMap.clear();
        process.write("Time fragments are cleaned.\n");
        process.write(affect.toString()).write("\n");
        process.end();
    }

    private void processList(CommandProcess process) {
        RowAffect affect = new RowAffect();
        process.write(RenderUtil.render(TimeTunnelTable.drawTimeTunnelTable(timeFragmentMap), process.width()));
        affect.rCnt(timeFragmentMap.size());
        process.write(affect.toString()).write("\n");
        process.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlay(CommandProcess process) {
        TimeFragment tf = timeFragmentMap.get(this.index);
        if (null == tf) {
            process.write(String.format("Time fragment[%d] does not exist.", this.index) + "\n");
            process.end();
            return;
        }
        Advice advice = tf.getAdvice();
        String className = advice.getClazz().getName();
        String methodName = advice.getMethod().getName();
        String objectAddress = advice.getTarget() == null ? "NULL" : "0x" + Integer.toHexString(advice.getTarget().hashCode());
        ArthasMethod method = advice.getMethod();
        boolean accessible = advice.getMethod().isAccessible();
        try {
            if (!accessible) {
                method.setAccessible(true);
            }
            for (int i = 0; i < this.getReplayTimes(); ++i) {
                if (i > 0) {
                    Thread.sleep(this.getReplayInterval());
                    if (!process.isRunning()) {
                        return;
                    }
                }
                long beginTime = System.nanoTime();
                TableElement table = TimeTunnelTable.createDefaultTable();
                if (i != 0) {
                    process.write("\n");
                }
                TimeTunnelTable.drawPlayHeader(className, methodName, objectAddress, this.index, table);
                TimeTunnelTable.drawParameters(advice, table, this.isNeedExpand(), this.expand);
                try {
                    Object returnObj = method.invoke(advice.getTarget(), advice.getParams());
                    double cost = (double)(System.nanoTime() - beginTime) / 1000000.0;
                    TimeTunnelTable.drawPlayResult(table, returnObj, this.isNeedExpand(), this.expand, this.sizeLimit, cost);
                }
                catch (Throwable t) {
                    TimeTunnelTable.drawPlayException(table, t, this.isNeedExpand(), this.expand);
                }
                process.write(RenderUtil.render(table, process.width())).write(String.format("Time fragment[%d] successfully replayed %d times.", this.index, i + 1)).write("\n");
            }
        }
        catch (Throwable t) {
            logger.warn("tt replay failed.", t);
        }
        finally {
            method.setAccessible(accessible);
            process.end();
        }
    }
}

