/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.Enhancer;
import com.taobao.arthas.core.advisor.InvokeTraceable;
import com.taobao.arthas.core.command.monitor200.AbstractTraceAdviceListener;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.logger.Logger;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Collections;
import java.util.List;

public abstract class EnhancerCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    protected static final List<String> EMPTY = Collections.emptyList();
    public static final String[] EXPRESS_EXAMPLES = new String[]{"params", "returnObj", "throwExp", "target", "clazz", "method", "{params,returnObj}", "params[0]"};
    protected Matcher classNameMatcher;
    protected Matcher methodNameMatcher;

    protected abstract Matcher getClassNameMatcher();

    protected abstract Matcher getMethodNameMatcher();

    protected abstract AdviceListener getAdviceListener(CommandProcess var1);

    @Override
    public void process(CommandProcess process) {
        process.interruptHandler(new CommandInterruptHandler(process));
        process.stdinHandler(new QExitHandler(process));
        this.enhance(process);
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!CompletionUtils.completeClassName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!CompletionUtils.completeMethodName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 3) {
            this.completeArgument3(completion);
            return;
        }
        super.complete(completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enhance(CommandProcess process) {
        Session session = process.session();
        if (!session.tryLock()) {
            process.write("someone else is enhancing classes, pls. wait.\n");
            process.end();
            return;
        }
        int lock = session.getLock();
        try {
            EnhancerAffect effect;
            Instrumentation inst = session.getInstrumentation();
            AdviceListener listener = this.getAdviceListener(process);
            if (listener == null) {
                EnhancerCommand.warn(process, "advice listener is null");
                return;
            }
            boolean skipJDKTrace = false;
            if (listener instanceof AbstractTraceAdviceListener) {
                skipJDKTrace = ((AbstractTraceAdviceListener)listener).getCommand().isSkipJDKTrace();
            }
            if ((effect = Enhancer.enhance(inst, lock, listener instanceof InvokeTraceable, skipJDKTrace, this.getClassNameMatcher(), this.getMethodNameMatcher())).cCnt() == 0 || effect.mCnt() == 0) {
                process.write("No class or method is affected, try:\n1. sm CLASS_NAME METHOD_NAME to make sure the method you are tracing actually exists (it might be in your parent class).\n2. reset CLASS_NAME and try again, your method body might be too large.\n3. check arthas log: " + LogUtil.LOGGER_FILE + "\n4. visit https://github.com/alibaba/arthas/issues/47 for more details.\n");
                process.end();
                return;
            }
            if (session.getLock() == lock) {
                process.register(lock, listener);
                if (process.isForeground()) {
                    process.echoTips("Press Q or Ctrl+C to abort.\n");
                }
            }
            process.write(effect + "\n");
        }
        catch (UnmodifiableClassException e) {
            logger.error(null, "error happens when enhancing class", e);
        }
        finally {
            if (session.getLock() == lock) {
                process.session().unLock();
            }
        }
    }

    protected void completeArgument3(Completion completion) {
        super.complete(completion);
    }

    private static void warn(CommandProcess process, String message) {
        logger.error(null, message);
        process.write("cannot operate the current command, pls. check arthas.log\n");
        if (process.isForeground()) {
            process.echoTips("Press Q or Ctrl+C to abort.\n");
        }
    }
}

