/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.AdviceWeaver;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.reflect.FieldUtils;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class Enhancer
implements ClassFileTransformer {
    private static final Logger logger = LogUtil.getArthasLogger();
    private final int adviceId;
    private final boolean isTracing;
    private final boolean skipJDKTrace;
    private final Set<Class<?>> matchingClasses;
    private final Matcher methodNameMatcher;
    private final EnhancerAffect affect;
    private static final Map<Class<?>, byte[]> classBytesCache = new WeakHashMap();

    private Enhancer(int adviceId, boolean isTracing, boolean skipJDKTrace, Set<Class<?>> matchingClasses, Matcher methodNameMatcher, EnhancerAffect affect) {
        this.adviceId = adviceId;
        this.isTracing = isTracing;
        this.skipJDKTrace = skipJDKTrace;
        this.matchingClasses = matchingClasses;
        this.methodNameMatcher = methodNameMatcher;
        this.affect = affect;
    }

    private void spy(ClassLoader targetClassLoader) throws Exception {
        if (targetClassLoader == null) {
            return;
        }
        Class<?> spyClass = targetClassLoader.loadClass("java.arthas.Spy");
        ClassLoader arthasClassLoader = Enhancer.class.getClassLoader();
        Method initMethod = spyClass.getMethod("init", ClassLoader.class, Method.class, Method.class, Method.class, Method.class, Method.class, Method.class);
        initMethod.invoke(null, arthasClassLoader, FieldUtils.getField(spyClass, "ON_BEFORE_METHOD").get(null), FieldUtils.getField(spyClass, "ON_RETURN_METHOD").get(null), FieldUtils.getField(spyClass, "ON_THROWS_METHOD").get(null), FieldUtils.getField(spyClass, "BEFORE_INVOKING_METHOD").get(null), FieldUtils.getField(spyClass, "AFTER_INVOKING_METHOD").get(null), FieldUtils.getField(spyClass, "THROW_INVOKING_METHOD").get(null));
    }

    @Override
    public byte[] transform(final ClassLoader inClassLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (!this.matchingClasses.contains(classBeingRedefined)) {
                return null;
            }
            byte[] byteOfClassInCache = classBytesCache.get(classBeingRedefined);
            ClassReader cr = null != byteOfClassInCache ? new ClassReader(byteOfClassInCache) : new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(cr, 3){

                @Override
                protected String getCommonSuperClass(String type1, String type2) {
                    Class<?> d;
                    Class<?> c;
                    ClassLoader classLoader = inClassLoader;
                    try {
                        c = Class.forName(type1.replace('/', '.'), false, classLoader);
                        d = Class.forName(type2.replace('/', '.'), false, classLoader);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (c.isAssignableFrom(d)) {
                        return type1;
                    }
                    if (d.isAssignableFrom(c)) {
                        return type2;
                    }
                    if (c.isInterface() || d.isInterface()) {
                        return "java/lang/Object";
                    }
                    while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                    }
                    return c.getName().replace('.', '/');
                }
            };
            cr.accept(new AdviceWeaver(this.adviceId, this.isTracing, this.skipJDKTrace, cr.getClassName(), this.methodNameMatcher, this.affect, cw), 8);
            byte[] enhanceClassByteArray = cw.toByteArray();
            classBytesCache.put(classBeingRedefined, enhanceClassByteArray);
            Enhancer.dumpClassIfNecessary(className, enhanceClassByteArray, this.affect);
            this.affect.cCnt(1);
            try {
                this.spy(inClassLoader);
            }
            catch (Throwable t) {
                logger.warn("print spy failed. classname={};loader={};", className, inClassLoader, t);
                throw t;
            }
            return enhanceClassByteArray;
        }
        catch (Throwable t) {
            logger.warn("transform loader[{}]:class[{}] failed.", inClassLoader, className, t);
            return null;
        }
    }

    private static void dumpClassIfNecessary(String className, byte[] data, EnhancerAffect affect) {
        if (!GlobalOptions.isDump) {
            return;
        }
        File dumpClassFile = new File("./arthas-class-dump/" + className + ".class");
        File classPath = new File(dumpClassFile.getParent());
        if (!classPath.mkdirs() && !classPath.exists()) {
            logger.warn("create dump classpath:{} failed.", classPath);
            return;
        }
        try {
            FileUtils.writeByteArrayToFile(dumpClassFile, data);
            affect.getClassDumpFiles().add(dumpClassFile);
        }
        catch (IOException e) {
            logger.warn("dump class:{} to file {} failed.", className, dumpClassFile, e);
        }
    }

    private static void filter(Set<Class<?>> classes) {
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> clazz = it.next();
            if (null != clazz && !Enhancer.isSelf(clazz) && !Enhancer.isUnsafeClass(clazz) && !Enhancer.isUnsupportedClass(clazz)) continue;
            it.remove();
        }
    }

    private static boolean isSelf(Class<?> clazz) {
        return null != clazz && ArthasCheckUtils.isEquals(clazz.getClassLoader(), Enhancer.class.getClassLoader());
    }

    private static boolean isUnsafeClass(Class<?> clazz) {
        return !GlobalOptions.isUnsafe && clazz.getClassLoader() == null;
    }

    private static boolean isUnsupportedClass(Class<?> clazz) {
        return clazz.isArray() || clazz.isInterface() || clazz.isEnum() || clazz.equals(Class.class) || clazz.equals(Integer.class) || clazz.equals(Method.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized EnhancerAffect enhance(Instrumentation inst, int adviceId, boolean isTracing, boolean skipJDKTrace, Matcher classNameMatcher, Matcher methodNameMatcher) throws UnmodifiableClassException {
        EnhancerAffect affect = new EnhancerAffect();
        Set<Class<?>> enhanceClassSet = GlobalOptions.isDisableSubClass ? SearchUtils.searchClass(inst, classNameMatcher) : SearchUtils.searchSubClass(inst, SearchUtils.searchClass(inst, classNameMatcher));
        Enhancer.filter(enhanceClassSet);
        Enhancer enhancer = new Enhancer(adviceId, isTracing, skipJDKTrace, enhanceClassSet, methodNameMatcher, affect);
        try {
            inst.addTransformer(enhancer, true);
            if (GlobalOptions.isBatchReTransform) {
                int size = enhanceClassSet.size();
                Object[] classArray = new Class[size];
                System.arraycopy(enhanceClassSet.toArray(), 0, classArray, 0, size);
                if (classArray.length <= 0) return affect;
                inst.retransformClasses((Class<?>[])classArray);
                logger.info("Success to batch transform classes: " + Arrays.toString(classArray));
                return affect;
            }
            Iterator<Class<?>> iterator = enhanceClassSet.iterator();
            while (iterator.hasNext()) {
                Class<?> clazz = iterator.next();
                try {
                    inst.retransformClasses(clazz);
                    logger.info("Success to transform class: " + clazz);
                }
                catch (Throwable t) {
                    logger.warn("retransform {} failed.", clazz, t);
                    if (t instanceof UnmodifiableClassException) {
                        throw (UnmodifiableClassException)t;
                    }
                    if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
                    throw (RuntimeException)t;
                }
            }
            return affect;
        }
        finally {
            inst.removeTransformer(enhancer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EnhancerAffect reset(Instrumentation inst, Matcher classNameMatcher) throws UnmodifiableClassException {
        EnhancerAffect affect = new EnhancerAffect();
        HashSet enhanceClassSet = new HashSet();
        for (Class<?> classInCache : classBytesCache.keySet()) {
            if (!classNameMatcher.matching(classInCache.getName())) continue;
            enhanceClassSet.add(classInCache);
        }
        ClassFileTransformer resetClassFileTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                return null;
            }
        };
        try {
            Enhancer.enhance(inst, resetClassFileTransformer, enhanceClassSet);
            logger.info("Success to reset classes: " + enhanceClassSet);
        }
        finally {
            for (Class clazz : enhanceClassSet) {
                classBytesCache.remove(clazz);
                affect.cCnt(1);
            }
        }
        return affect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enhance(Instrumentation inst, ClassFileTransformer transformer, Set<Class<?>> classes) throws UnmodifiableClassException {
        try {
            inst.addTransformer(transformer, true);
            int size = classes.size();
            Class[] classArray = new Class[size];
            System.arraycopy(classes.toArray(), 0, classArray, 0, size);
            if (classArray.length > 0) {
                inst.retransformClasses(classArray);
            }
        }
        finally {
            inst.removeTransformer(transformer);
        }
    }
}

