/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.CodeLock;
import com.taobao.arthas.core.advisor.InvokeTraceable;
import com.taobao.arthas.core.advisor.TracingAsmCodeLock;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.collection.GaStack;
import com.taobao.arthas.core.util.collection.ThreadUnsafeFixGaStack;
import com.taobao.arthas.core.util.collection.ThreadUnsafeGaStack;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.commons.Method;

public class AdviceWeaver
extends ClassVisitor
implements Opcodes {
    private static final Logger logger = LogUtil.getArthasLogger();
    private static final int FRAME_STACK_SIZE = 7;
    private static final Map<Integer, AdviceListener> advices = new ConcurrentHashMap<Integer, AdviceListener>();
    private static final ThreadLocal<GaStack<GaStack<Object>>> threadBoundContext = new ThreadLocal();
    private static final ThreadLocal<Boolean> isSelfCallRef = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final int adviceId;
    private final boolean isTracing;
    private final boolean skipJDKTrace;
    private final String className;
    private String superName;
    private final Matcher matcher;
    private final EnhancerAffect affect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void methodOnBegin(int adviceId, ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args) {
        if (isSelfCallRef.get().booleanValue()) {
            return;
        }
        isSelfCallRef.set(true);
        try {
            ThreadUnsafeFixGaStack<Object> frameStack = new ThreadUnsafeFixGaStack<Object>(7);
            frameStack.push(loader);
            frameStack.push(className);
            frameStack.push(methodName);
            frameStack.push(methodDesc);
            frameStack.push(target);
            frameStack.push(args);
            AdviceListener listener = AdviceWeaver.getListener(adviceId);
            frameStack.push(listener);
            AdviceWeaver.before(listener, loader, className, methodName, methodDesc, target, args);
            AdviceWeaver.threadFrameStackPush(frameStack);
        }
        finally {
            isSelfCallRef.set(false);
        }
    }

    public static void methodOnReturnEnd(Object returnObject) {
        AdviceWeaver.methodOnEnd(false, returnObject);
    }

    public static void methodOnThrowingEnd(Throwable throwable) {
        AdviceWeaver.methodOnEnd(true, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodOnEnd(boolean isThrowing, Object returnOrThrowable) {
        if (isSelfCallRef.get().booleanValue()) {
            return;
        }
        isSelfCallRef.set(true);
        try {
            GaStack<Object> frameStack = AdviceWeaver.threadFrameStackPop();
            AdviceListener listener = (AdviceListener)frameStack.pop();
            Object[] args = (Object[])frameStack.pop();
            Object target = frameStack.pop();
            String methodDesc = (String)frameStack.pop();
            String methodName = (String)frameStack.pop();
            String className = (String)frameStack.pop();
            ClassLoader loader = (ClassLoader)frameStack.pop();
            if (isThrowing) {
                AdviceWeaver.afterThrowing(listener, loader, className, methodName, methodDesc, target, args, (Throwable)returnOrThrowable);
            } else {
                AdviceWeaver.afterReturning(listener, loader, className, methodName, methodDesc, target, args, returnOrThrowable);
            }
        }
        finally {
            isSelfCallRef.set(false);
        }
    }

    public static void methodOnInvokeBeforeTracing(int adviceId, String owner, String name, String desc, int lineNumber) {
        InvokeTraceable listener = (InvokeTraceable)((Object)AdviceWeaver.getListener(adviceId));
        if (null != listener) {
            try {
                listener.invokeBeforeTracing(owner, name, desc, lineNumber);
            }
            catch (Throwable t) {
                logger.warn("advice before tracing failed.", t);
            }
        }
    }

    public static void methodOnInvokeAfterTracing(int adviceId, String owner, String name, String desc, int lineNumber) {
        InvokeTraceable listener = (InvokeTraceable)((Object)AdviceWeaver.getListener(adviceId));
        if (null != listener) {
            try {
                listener.invokeAfterTracing(owner, name, desc, lineNumber);
            }
            catch (Throwable t) {
                logger.warn("advice after tracing failed.", t);
            }
        }
    }

    public static void methodOnInvokeThrowTracing(int adviceId, String owner, String name, String desc, int lineNumber) {
        InvokeTraceable listener = (InvokeTraceable)((Object)AdviceWeaver.getListener(adviceId));
        if (null != listener) {
            try {
                listener.invokeThrowTracing(owner, name, desc, lineNumber);
            }
            catch (Throwable t) {
                logger.warn("advice throw tracing failed.", t);
            }
        }
    }

    private static void threadFrameStackPush(GaStack<Object> frameStack) {
        GaStack<GaStack<Object>> threadFrameStack = threadBoundContext.get();
        if (null == threadFrameStack) {
            threadFrameStack = new ThreadUnsafeGaStack<GaStack<Object>>();
            threadBoundContext.set(threadFrameStack);
        }
        threadFrameStack.push(frameStack);
    }

    private static GaStack<Object> threadFrameStackPop() {
        return threadBoundContext.get().pop();
    }

    private static AdviceListener getListener(int adviceId) {
        return advices.get(adviceId);
    }

    public static void reg(int adviceId, AdviceListener listener) {
        listener.create();
        advices.put(adviceId, listener);
    }

    public static void unReg(int adviceId) {
        AdviceListener listener = advices.remove(adviceId);
        if (null != listener) {
            listener.destroy();
        }
    }

    public static void resume(int adviceId, AdviceListener listener) {
        advices.put(adviceId, listener);
    }

    public static AdviceListener suspend(int adviceId) {
        return advices.remove(adviceId);
    }

    private static void before(AdviceListener listener, ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args) {
        if (null != listener) {
            try {
                listener.before(loader, className, methodName, methodDesc, target, args);
            }
            catch (Throwable t) {
                logger.warn("advice before failed.", t);
            }
        }
    }

    private static void afterReturning(AdviceListener listener, ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args, Object returnObject) {
        if (null != listener) {
            try {
                listener.afterReturning(loader, className, methodName, methodDesc, target, args, returnObject);
            }
            catch (Throwable t) {
                logger.warn("advice returning failed.", t);
            }
        }
    }

    private static void afterThrowing(AdviceListener listener, ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args, Throwable throwable) {
        if (null != listener) {
            try {
                listener.afterThrowing(loader, className, methodName, methodDesc, target, args, throwable);
            }
            catch (Throwable t) {
                logger.warn("advice throwing failed.", t);
            }
        }
    }

    public AdviceWeaver(int adviceId, boolean isTracing, boolean skipJDKTrace, String className, Matcher matcher, EnhancerAffect affect, ClassVisitor cv) {
        super(458752, cv);
        this.adviceId = adviceId;
        this.isTracing = isTracing;
        this.skipJDKTrace = skipJDKTrace;
        this.className = className;
        this.matcher = matcher;
        this.affect = affect;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
    }

    protected boolean isSuperOrSiblingConstructorCall(int opcode, String owner, String name) {
        return opcode == 183 && name.equals("<init>") && (this.superName.equals(owner) || this.className.equals(owner));
    }

    private boolean isAbstract(int access) {
        return (0x400 & access) == 1024;
    }

    private boolean isIgnore(MethodVisitor mv, int access, String methodName) {
        return null == mv || this.isAbstract(access) || !this.matcher.matching(methodName) || ArthasCheckUtils.isEquals(methodName, "<clinit>");
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.isIgnore(mv, access, name)) {
            return mv;
        }
        this.affect.mCnt(1);
        return new AdviceAdapter(458752, new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions), access, name, desc){
            private final Label beginLabel;
            private final Label endLabel;
            private final int KEY_ARTHAS_ADVICE_BEFORE_METHOD = 0;
            private final int KEY_ARTHAS_ADVICE_RETURN_METHOD = 1;
            private final int KEY_ARTHAS_ADVICE_THROWS_METHOD = 2;
            private final int KEY_ARTHAS_ADVICE_BEFORE_INVOKING_METHOD = 3;
            private final int KEY_ARTHAS_ADVICE_AFTER_INVOKING_METHOD = 4;
            private final int KEY_ARTHAS_ADVICE_THROW_INVOKING_METHOD = 5;
            private final Type ASM_TYPE_SPY;
            private final Type ASM_TYPE_OBJECT;
            private final Type ASM_TYPE_OBJECT_ARRAY;
            private final Type ASM_TYPE_CLASS;
            private final Type ASM_TYPE_INTEGER;
            private final Type ASM_TYPE_CLASS_LOADER;
            private final Type ASM_TYPE_STRING;
            private final Type ASM_TYPE_THROWABLE;
            private final Type ASM_TYPE_INT;
            private final Type ASM_TYPE_METHOD;
            private final Method ASM_METHOD_METHOD_INVOKE;
            private final CodeLock codeLockForTracing;
            private int lineNumber;
            List<AsmTryCatchBlock> tcbs;
            {
                super(x0, x1, x2, x3, x4);
                this.beginLabel = new Label();
                this.endLabel = new Label();
                this.KEY_ARTHAS_ADVICE_BEFORE_METHOD = 0;
                this.KEY_ARTHAS_ADVICE_RETURN_METHOD = 1;
                this.KEY_ARTHAS_ADVICE_THROWS_METHOD = 2;
                this.KEY_ARTHAS_ADVICE_BEFORE_INVOKING_METHOD = 3;
                this.KEY_ARTHAS_ADVICE_AFTER_INVOKING_METHOD = 4;
                this.KEY_ARTHAS_ADVICE_THROW_INVOKING_METHOD = 5;
                this.ASM_TYPE_SPY = Type.getType("Ljava/arthas/Spy;");
                this.ASM_TYPE_OBJECT = Type.getType(Object.class);
                this.ASM_TYPE_OBJECT_ARRAY = Type.getType(Object[].class);
                this.ASM_TYPE_CLASS = Type.getType(Class.class);
                this.ASM_TYPE_INTEGER = Type.getType(Integer.class);
                this.ASM_TYPE_CLASS_LOADER = Type.getType(ClassLoader.class);
                this.ASM_TYPE_STRING = Type.getType(String.class);
                this.ASM_TYPE_THROWABLE = Type.getType(Throwable.class);
                this.ASM_TYPE_INT = Type.getType(Integer.TYPE);
                this.ASM_TYPE_METHOD = Type.getType(java.lang.reflect.Method.class);
                this.ASM_METHOD_METHOD_INVOKE = Method.getMethod("Object invoke(Object,Object[])");
                this.codeLockForTracing = new TracingAsmCodeLock(this);
                this.tcbs = new ArrayList<AsmTryCatchBlock>();
            }

            private void _debug(StringBuilder append, String msg) {
                if (!GlobalOptions.isDebugForAsm) {
                    return;
                }
                this.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
                if (StringUtils.isBlank(append.toString())) {
                    this.visitLdcInsn(append.append(msg).toString());
                } else {
                    this.visitLdcInsn(append.append(" >> ").append(msg).toString());
                }
                this.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
            }

            private void loadAdviceMethod(int keyOfMethod) {
                switch (keyOfMethod) {
                    case 0: {
                        this.getStatic(this.ASM_TYPE_SPY, "ON_BEFORE_METHOD", this.ASM_TYPE_METHOD);
                        break;
                    }
                    case 1: {
                        this.getStatic(this.ASM_TYPE_SPY, "ON_RETURN_METHOD", this.ASM_TYPE_METHOD);
                        break;
                    }
                    case 2: {
                        this.getStatic(this.ASM_TYPE_SPY, "ON_THROWS_METHOD", this.ASM_TYPE_METHOD);
                        break;
                    }
                    case 3: {
                        this.getStatic(this.ASM_TYPE_SPY, "BEFORE_INVOKING_METHOD", this.ASM_TYPE_METHOD);
                        break;
                    }
                    case 4: {
                        this.getStatic(this.ASM_TYPE_SPY, "AFTER_INVOKING_METHOD", this.ASM_TYPE_METHOD);
                        break;
                    }
                    case 5: {
                        this.getStatic(this.ASM_TYPE_SPY, "THROW_INVOKING_METHOD", this.ASM_TYPE_METHOD);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal keyOfMethod=" + keyOfMethod);
                    }
                }
            }

            private void loadClassLoader() {
                if (this.isStaticMethod()) {
                    this.visitLdcInsn(StringUtils.normalizeClassName(AdviceWeaver.this.className));
                    this.invokeStatic(this.ASM_TYPE_CLASS, Method.getMethod("Class forName(String)"));
                    this.invokeVirtual(this.ASM_TYPE_CLASS, Method.getMethod("ClassLoader getClassLoader()"));
                } else {
                    this.loadThis();
                    this.invokeVirtual(this.ASM_TYPE_OBJECT, Method.getMethod("Class getClass()"));
                    this.invokeVirtual(this.ASM_TYPE_CLASS, Method.getMethod("ClassLoader getClassLoader()"));
                }
            }

            private void loadArrayForBefore() {
                this.push(7);
                this.newArray(this.ASM_TYPE_OBJECT);
                this.dup();
                this.push(0);
                this.push(AdviceWeaver.this.adviceId);
                this.box(this.ASM_TYPE_INT);
                this.arrayStore(this.ASM_TYPE_INTEGER);
                this.dup();
                this.push(1);
                this.loadClassLoader();
                this.arrayStore(this.ASM_TYPE_CLASS_LOADER);
                this.dup();
                this.push(2);
                this.push(AdviceWeaver.this.className);
                this.arrayStore(this.ASM_TYPE_STRING);
                this.dup();
                this.push(3);
                this.push(name);
                this.arrayStore(this.ASM_TYPE_STRING);
                this.dup();
                this.push(4);
                this.push(desc);
                this.arrayStore(this.ASM_TYPE_STRING);
                this.dup();
                this.push(5);
                this.loadThisOrPushNullIfIsStatic();
                this.arrayStore(this.ASM_TYPE_OBJECT);
                this.dup();
                this.push(6);
                this.loadArgArray();
                this.arrayStore(this.ASM_TYPE_OBJECT_ARRAY);
            }

            @Override
            protected void onMethodEnter() {
                this.codeLockForTracing.lock(new CodeLock.Block(){

                    @Override
                    public void code() {
                        StringBuilder append = new StringBuilder();
                        this._debug(append, "debug:onMethodEnter()");
                        this.loadAdviceMethod(0);
                        this._debug(append, "debug:onMethodEnter() > loadAdviceMethod()");
                        this.pushNull();
                        this.loadArrayForBefore();
                        this._debug(append, "debug:onMethodEnter() > loadAdviceMethod() > loadArrayForBefore()");
                        this.invokeVirtual(ASM_TYPE_METHOD, ASM_METHOD_METHOD_INVOKE);
                        this.pop();
                        this._debug(append, "debug:onMethodEnter() > loadAdviceMethod() > loadArrayForBefore() > invokeVirtual()");
                    }
                });
                this.mark(this.beginLabel);
            }

            private void loadReturnArgs() {
                this.dup2X1();
                this.pop2();
                this.push(1);
                this.newArray(this.ASM_TYPE_OBJECT);
                this.dup();
                this.dup2X1();
                this.pop2();
                this.push(0);
                this.swap();
                this.arrayStore(this.ASM_TYPE_OBJECT);
            }

            @Override
            protected void onMethodExit(final int opcode) {
                if (!this.isThrow(opcode)) {
                    this.codeLockForTracing.lock(new CodeLock.Block(){

                        @Override
                        public void code() {
                            StringBuilder append = new StringBuilder();
                            this._debug(append, "debug:onMethodExit()");
                            this.loadReturn(opcode);
                            this._debug(append, "debug:onMethodExit() > loadReturn()");
                            this.loadAdviceMethod(1);
                            this._debug(append, "debug:onMethodExit() > loadReturn() > loadAdviceMethod()");
                            this.pushNull();
                            this.loadReturnArgs();
                            this._debug(append, "debug:onMethodExit() > loadReturn() > loadAdviceMethod() > loadReturnArgs()");
                            this.invokeVirtual(ASM_TYPE_METHOD, ASM_METHOD_METHOD_INVOKE);
                            this.pop();
                            this._debug(append, "debug:onMethodExit() > loadReturn() > loadAdviceMethod() > loadReturnArgs() > invokeVirtual()");
                        }
                    });
                }
            }

            private void loadThrowArgs() {
                this.dup2X1();
                this.pop2();
                this.push(1);
                this.newArray(this.ASM_TYPE_OBJECT);
                this.dup();
                this.dup2X1();
                this.pop2();
                this.push(0);
                this.swap();
                this.arrayStore(this.ASM_TYPE_THROWABLE);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                this.mark(this.endLabel);
                this.visitTryCatchBlock(this.beginLabel, this.endLabel, this.mark(), this.ASM_TYPE_THROWABLE.getInternalName());
                this.codeLockForTracing.lock(new CodeLock.Block(){

                    @Override
                    public void code() {
                        StringBuilder append = new StringBuilder();
                        this._debug(append, "debug:catchException()");
                        this.loadThrow();
                        this._debug(append, "debug:catchException() > loadThrow() > loadAdviceMethod()");
                        this.loadAdviceMethod(2);
                        this._debug(append, "debug:catchException() > loadThrow() > loadAdviceMethod()");
                        this.pushNull();
                        this.loadThrowArgs();
                        this._debug(append, "debug:catchException() > loadThrow() > loadAdviceMethod() > loadThrowArgs()");
                        this.invokeVirtual(ASM_TYPE_METHOD, ASM_METHOD_METHOD_INVOKE);
                        this.pop();
                        this._debug(append, "debug:catchException() > loadThrow() > loadAdviceMethod() > loadThrowArgs() > invokeVirtual()");
                    }
                });
                this.throwException();
                super.visitMaxs(maxStack, maxLocals);
            }

            @Override
            public void visitLineNumber(int line, Label start) {
                super.visitLineNumber(line, start);
                this.lineNumber = line;
            }

            private boolean isStaticMethod() {
                return (this.methodAccess & 8) != 0;
            }

            private boolean isThrow(int opcode) {
                return opcode == 191;
            }

            private void pushNull() {
                this.push((Type)null);
            }

            private void loadThisOrPushNullIfIsStatic() {
                if (this.isStaticMethod()) {
                    this.pushNull();
                } else {
                    this.loadThis();
                }
            }

            private void loadReturn(int opcode) {
                switch (opcode) {
                    case 177: {
                        this.pushNull();
                        break;
                    }
                    case 176: {
                        this.dup();
                        break;
                    }
                    case 173: 
                    case 175: {
                        this.dup2();
                        this.box(Type.getReturnType(this.methodDesc));
                        break;
                    }
                    default: {
                        this.dup();
                        this.box(Type.getReturnType(this.methodDesc));
                    }
                }
            }

            private void loadThrow() {
                this.dup();
            }

            private void loadArrayForInvokeTracing(String owner, String name2, String desc2, int lineNumber) {
                this.push(5);
                this.newArray(this.ASM_TYPE_OBJECT);
                this.dup();
                this.push(0);
                this.push(AdviceWeaver.this.adviceId);
                this.box(this.ASM_TYPE_INT);
                this.arrayStore(this.ASM_TYPE_INTEGER);
                this.dup();
                this.push(1);
                this.push(owner);
                this.arrayStore(this.ASM_TYPE_STRING);
                this.dup();
                this.push(2);
                this.push(name2);
                this.arrayStore(this.ASM_TYPE_STRING);
                this.dup();
                this.push(3);
                this.push(desc2);
                this.arrayStore(this.ASM_TYPE_STRING);
                this.dup();
                this.push(4);
                this.push(lineNumber);
                this.box(this.ASM_TYPE_INT);
                this.arrayStore(this.ASM_TYPE_INTEGER);
            }

            @Override
            public void visitInsn(int opcode) {
                super.visitInsn(opcode);
                this.codeLockForTracing.code(opcode);
            }

            @Override
            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                this.tcbs.add(new AsmTryCatchBlock(start, end, handler, type));
            }

            @Override
            public void visitEnd() {
                for (AsmTryCatchBlock tcb : this.tcbs) {
                    super.visitTryCatchBlock(tcb.start, tcb.end, tcb.handler, tcb.type);
                }
                super.visitEnd();
            }

            private void tracing(final int tracingType, final String owner, final String name2, final String desc2, final int lineNumber) {
                String label;
                switch (tracingType) {
                    case 3: {
                        label = "beforeInvoking";
                        break;
                    }
                    case 4: {
                        label = "afterInvoking";
                        break;
                    }
                    case 5: {
                        label = "throwInvoking";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("illegal tracing type: " + tracingType);
                    }
                }
                this.codeLockForTracing.lock(new CodeLock.Block(){

                    @Override
                    public void code() {
                        StringBuilder append = new StringBuilder();
                        this._debug(append, "debug:" + label + "()");
                        this.loadAdviceMethod(tracingType);
                        this._debug(append, "loadAdviceMethod()");
                        this.pushNull();
                        this.loadArrayForInvokeTracing(owner, name2, desc2, lineNumber);
                        this._debug(append, "loadArrayForInvokeTracing()");
                        this.invokeVirtual(ASM_TYPE_METHOD, ASM_METHOD_METHOD_INVOKE);
                        this.pop();
                        this._debug(append, "invokeVirtual()");
                    }
                });
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                if (AdviceWeaver.this.isSuperOrSiblingConstructorCall(opcode, owner, name2)) {
                    super.visitMethodInsn(opcode, owner, name2, desc2, itf);
                    return;
                }
                if (!AdviceWeaver.this.isTracing || this.codeLockForTracing.isLock()) {
                    super.visitMethodInsn(opcode, owner, name2, desc2, itf);
                    return;
                }
                if (AdviceWeaver.this.skipJDKTrace && owner.startsWith("java/")) {
                    super.visitMethodInsn(opcode, owner, name2, desc2, itf);
                    return;
                }
                this.tracing(3, owner, name2, desc2, this.lineNumber);
                Label beginLabel = new Label();
                Label endLabel = new Label();
                Label finallyLabel = new Label();
                this.mark(beginLabel);
                super.visitMethodInsn(opcode, owner, name2, desc2, itf);
                this.mark(endLabel);
                this.tracing(4, owner, name2, desc2, this.lineNumber);
                this.goTo(finallyLabel);
                this.catchException(beginLabel, endLabel, this.ASM_TYPE_THROWABLE);
                this.tracing(5, owner, name2, desc2, this.lineNumber);
                this.throwException();
                this.mark(finallyLabel);
            }
        };
    }

    static class AsmTryCatchBlock {
        Label start;
        Label end;
        Label handler;
        String type;

        AsmTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

