/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.JavaVersionUtils;
import com.taobao.arthas.core.config.Configure;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CLIs;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.TypedOption;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Properties;

public class Arthas {
    private static final String DEFAULT_TELNET_PORT = "3658";
    private static final String DEFAULT_HTTP_PORT = "8563";

    private Arthas(String[] args) throws Exception {
        this.attachAgent(this.parse(args));
    }

    private Configure parse(String[] args) {
        Option pid = ((TypedOption)new TypedOption<Integer>().setType(Integer.class).setShortName("pid")).setRequired(true);
        Option core = ((TypedOption)new TypedOption<String>().setType(String.class).setShortName("core")).setRequired(true);
        Option agent = ((TypedOption)new TypedOption<String>().setType(String.class).setShortName("agent")).setRequired(true);
        Option target = new TypedOption<String>().setType(String.class).setShortName("target-ip");
        Option telnetPort = ((TypedOption)new TypedOption<Integer>().setType(Integer.class).setShortName("telnet-port")).setDefaultValue(DEFAULT_TELNET_PORT);
        Option httpPort = ((TypedOption)new TypedOption<Integer>().setType(Integer.class).setShortName("http-port")).setDefaultValue(DEFAULT_HTTP_PORT);
        Option sessionTimeout = ((TypedOption)new TypedOption<Integer>().setType(Integer.class).setShortName("session-timeout")).setDefaultValue("1800");
        CLI cli = CLIs.create("arthas").addOption(pid).addOption(core).addOption(agent).addOption(target).addOption(telnetPort).addOption(httpPort).addOption(sessionTimeout);
        CommandLine commandLine = cli.parse(Arrays.asList(args));
        Configure configure = new Configure();
        configure.setJavaPid((Integer)commandLine.getOptionValue("pid"));
        configure.setArthasAgent((String)commandLine.getOptionValue("agent"));
        configure.setArthasCore((String)commandLine.getOptionValue("core"));
        configure.setSessionTimeout(((Integer)commandLine.getOptionValue("session-timeout")).intValue());
        if (commandLine.getOptionValue("target-ip") == null) {
            throw new IllegalStateException("as.sh is too old to support web console, please run the following command to upgrade to latest version:\ncurl -sLk https://alibaba.github.io/arthas/install.sh | sh");
        }
        configure.setIp((String)commandLine.getOptionValue("target-ip"));
        configure.setTelnetPort((Integer)commandLine.getOptionValue("telnet-port"));
        configure.setHttpPort((Integer)commandLine.getOptionValue("http-port"));
        return configure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachAgent(Configure configure) throws Exception {
        VirtualMachineDescriptor virtualMachineDescriptor = null;
        for (VirtualMachineDescriptor descriptor : VirtualMachine.list()) {
            String pid = descriptor.id();
            if (!pid.equals(Integer.toString(configure.getJavaPid()))) continue;
            virtualMachineDescriptor = descriptor;
        }
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = null == virtualMachineDescriptor ? VirtualMachine.attach("" + configure.getJavaPid()) : VirtualMachine.attach(virtualMachineDescriptor);
            Properties targetSystemProperties = virtualMachine.getSystemProperties();
            String targetJavaVersion = JavaVersionUtils.javaVersionStr(targetSystemProperties);
            String currentJavaVersion = JavaVersionUtils.javaVersionStr();
            if (targetJavaVersion != null && currentJavaVersion != null && !targetJavaVersion.equals(currentJavaVersion)) {
                AnsiLog.warn("Current VM java version: {} do not match target VM java version: {}, attach may fail.", currentJavaVersion, targetJavaVersion);
                AnsiLog.warn("Target VM JAVA_HOME is {}, arthas-boot JAVA_HOME is {}, try to set the same JAVA_HOME.", targetSystemProperties.getProperty("java.home"), System.getProperty("java.home"));
            }
            String arthasAgentPath = configure.getArthasAgent();
            configure.setArthasAgent(Arthas.encodeArg(arthasAgentPath));
            configure.setArthasCore(Arthas.encodeArg(configure.getArthasCore()));
            virtualMachine.loadAgent(arthasAgentPath, configure.getArthasCore() + ";" + configure.toString());
        }
        finally {
            if (null != virtualMachine) {
                virtualMachine.detach();
            }
        }
    }

    private static String encodeArg(String arg) {
        try {
            return URLEncoder.encode(arg, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return arg;
        }
    }

    public static void main(String[] args) {
        try {
            new Arthas(args);
        }
        catch (Throwable t) {
            AnsiLog.error("Start arthas failed, exception stack trace: ");
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

